// VH73BParam.cpp : implementation file
//

#include "stdafx.h"
#include "hhda.h"
#include "hhdaParam.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//////////////////////////////////////////////////////////////////////////
HWND	gReaderParamHwnd	=	NULL;	//д


/////////////////////////////////////////////////////////////////////////////
// VH73BParam property page

IMPLEMENT_DYNCREATE(VH73BParam, CPropertyPage)

VH73BParam::VH73BParam() : CPropertyPage(VH73BParam::IDD)
{
	//{{AFX_DATA_INIT(VH73BParam)
		// NOTE: the ClassWizard will add member initialization here
	m_TagType			=		0;//0--6B,1--6C
	m_OutputType		=		0;//0-1-棬2-
	//}}AFX_DATA_INIT
}

VH73BParam::~VH73BParam()
{
}

void VH73BParam::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(VH73BParam)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Radio(pDX, IDC_RADIO_ISO6B, m_TagType);
	DDX_Radio(pDX, IDC_RADIO_SAVEANDOUTPUT, m_OutputType);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(VH73BParam, CPropertyPage)
	//{{AFX_MSG_MAP(VH73BParam)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_SETPARAM, OnButtonSetparam)
	ON_BN_CLICKED(IDC_BUTTON_READPARAM, OnButtonReadparam)
	ON_BN_CLICKED(IDC_BUTTON_SETFACPARAM, OnButtonSetfacparam)
	ON_BN_CLICKED(IDC_BUTTON_RESTOREFACPARAM, OnButtonRestorefacparam)
	ON_BN_CLICKED(IDC_BUTTON_PARAMSET, OnButtonParamset)
	ON_BN_CLICKED(IDC_BUTTON_GETTIME, OnButtonGettime)
	ON_BN_CLICKED(IDC_BUTTON_SETTIME, OnButtonSettime)
	ON_BN_CLICKED(IDC_BUTTON_SETFILTER, OnButtonSetfilter)
	ON_BN_CLICKED(IDC_BUTTON_GETFILTER, OnButtonGetfilter)
	ON_BN_CLICKED(IDC_BUTTON_ReaderGETBLUEID, OnBUTTONReaderGETBLUEID)
	ON_BN_CLICKED(IDC_BUTTON_ReadSETID, OnBUTTONReadSETID)
	ON_BN_CLICKED(IDC_BUTTON_GETRFParam, OnBUTTONGETRFParam)
	ON_BN_CLICKED(IDC_BUTTON_SETRFParam, OnBUTTONSETRFParam)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_READERPARMDATAMSG, OnReaderparmdatamsg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// VH73BParam message handlers

void VH73BParam::OnInitUIText()//ı
{
	SetWindowText(theApp.g_LoadString("IDWQE_C0001"));//
	
	GetDlgItem(IDC_STATIC_BASICPARAM)->SetWindowText(theApp.g_LoadString("IDWQE_C0002"));//
	GetDlgItem(IDC_STATIC_USBRATE)->SetWindowText(theApp.g_LoadString("IDWQE_C0003"));//USB
	GetDlgItem(IDC_STATIC_MINFREQ)->SetWindowText(theApp.g_LoadString("IDWQE_C0004"));//СƵ
	GetDlgItem(IDC_STATIC_MAXFREQ)->SetWindowText(theApp.g_LoadString("IDWQE_C0005"));//Ƶ
	GetDlgItem(IDC_STATIC_RFmodeHardVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0006"));//ƵģӲ汾
	GetDlgItem(IDC_STATIC_RFmodeSoftVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0007"));//Ƶģ汾
	GetDlgItem(IDC_CHECK_NAME)->SetWindowText(theApp.g_LoadString("IDWQE_C0008"));//
	GetDlgItem(IDC_CHECK_ALARM)->SetWindowText(theApp.g_LoadString("IDWQE_C0009"));//
	GetDlgItem(IDC_BUTTON_SETPARAM)->SetWindowText(theApp.g_LoadString("IDWQE_C0010"));//ò
	GetDlgItem(IDC_BUTTON_READPARAM)->SetWindowText(theApp.g_LoadString("IDWQE_C0011"));//ȡ
	GetDlgItem(IDC_BUTTON_SETFACPARAM)->SetWindowText(theApp.g_LoadString("IDWQE_C0012"));//ó
	GetDlgItem(IDC_BUTTON_RESTOREFACPARAM)->SetWindowText(theApp.g_LoadString("IDWQE_C0013"));//ó
	GetDlgItem(IDC_STATIC_TAGOPT)->SetWindowText(theApp.g_LoadString("IDWQE_C0014"));//ǩ
	GetDlgItem(IDC_RADIO_ISO6B)->SetWindowText(theApp.g_LoadString("IDWQE_C0015"));//ISO18000-6B
	GetDlgItem(IDC_RADIO_ISO6C)->SetWindowText(theApp.g_LoadString("IDWQE_C0016"));//ISO18000-6C
	GetDlgItem(IDC_STATIC_OutputOpt)->SetWindowText(theApp.g_LoadString("IDWQE_C0017"));//ʽ
	GetDlgItem(IDC_RADIO_SAVEANDOUTPUT)->SetWindowText(theApp.g_LoadString("IDWQE_C0018"));//
	GetDlgItem(IDC_RADIO_SAVEONLY)->SetWindowText(theApp.g_LoadString("IDWQE_C0019"));//
	GetDlgItem(IDC_RADIO_OUTPUTONLY)->SetWindowText(theApp.g_LoadString("IDWQE_C0020"));//
	GetDlgItem(IDC_STATIC_READTID)->SetWindowText(theApp.g_LoadString("IDWQE_C0021"));//ȡTID
	GetDlgItem(IDC_CHECK_TIDPART)->SetWindowText(theApp.g_LoadString("IDWQE_C0022"));//TID
	GetDlgItem(IDC_STATIC_TIDSTART)->SetWindowText(theApp.g_LoadString("IDWQE_C0023"));//ʼλ
	GetDlgItem(IDC_STATIC_TIDLength)->SetWindowText(theApp.g_LoadString("IDWQE_C0024"));//ȡ
	GetDlgItem(IDC_STATIC_USERPART)->SetWindowText(theApp.g_LoadString("IDWQE_C0025"));//USER
	GetDlgItem(IDC_CHECK_PARTUSER)->SetWindowText(theApp.g_LoadString("IDWQE_C0026"));//USER
	GetDlgItem(IDC_STATIC_USERSTART)->SetWindowText(theApp.g_LoadString("IDWQE_C0027"));//ʼλ
	GetDlgItem(IDC_STATIC_UserLength)->SetWindowText(theApp.g_LoadString("IDWQE_C0028"));//ȡ
	GetDlgItem(IDC_STATIC_PARAMHardVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0029"));//Ӳ汾
	GetDlgItem(IDC_STATIC_PARAMSoftVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0030"));//汾
	GetDlgItem(IDC_STATIC_PARAMMainVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0031"));//Ӳ汾
	GetDlgItem(IDC_STATIC_PARAMSecondVer)->SetWindowText(theApp.g_LoadString("IDWQE_C0032"));//ΰ汾
	GetDlgItem(IDC_BUTTON_PARAMSET)->SetWindowText(theApp.g_LoadString("IDWQE_C0033"));//
	GetDlgItem(IDC_STATIC_TIMESET)->SetWindowText(theApp.g_LoadString("IDWQE_C0034"));//ʱ
	GetDlgItem(IDC_BUTTON_GETTIME)->SetWindowText(theApp.g_LoadString("IDWQE_C0035"));//ȡʱ
	GetDlgItem(IDC_BUTTON_SETTIME)->SetWindowText(theApp.g_LoadString("IDWQE_C0036"));//ʱ
	GetDlgItem(IDC_STATIC_MASK)->SetWindowText(theApp.g_LoadString("IDWQE_C0037"));//
	GetDlgItem(IDC_STATIC_MASKSTARTADDR)->SetWindowText(theApp.g_LoadString("IDWQE_C0038"));//ʼַ
	GetDlgItem(IDC_STATIC_MASKLENGTH)->SetWindowText(theApp.g_LoadString("IDWQE_C0039"));//볤
	GetDlgItem(IDC_STATIC_MASKDATA)->SetWindowText(theApp.g_LoadString("IDWQE_C0040"));//(HEX)
	GetDlgItem(IDC_BUTTON_SETFILTER)->SetWindowText(theApp.g_LoadString("IDWQE_C0041"));//ù
	GetDlgItem(IDC_BUTTON_GETFILTER)->SetWindowText(theApp.g_LoadString("IDWQE_C0042"));//ȡ
	GetDlgItem(IDC_STATIC_RFPower)->SetWindowText(theApp.g_LoadString("IDWQE_C0043"));//书


	GetDlgItem(IDC_STATIC_BTREADID)->SetWindowText(theApp.g_LoadString("IDWQE_C0068"));//ֳֻID
	GetDlgItem(IDC_BUTTON_ReaderGETBLUEID)->SetWindowText(theApp.g_LoadString("IDWQE_C0069"));//ȡID
	GetDlgItem(IDC_BUTTON_ReadSETID)->SetWindowText(theApp.g_LoadString("IDWQE_C0070"));//ID
	GetDlgItem(IDC_STATIC_RFGROUPMODE)->SetWindowText(theApp.g_LoadString("IDWQE_C0071"));//Ƶģ


	GetDlgItem(IDC_BUTTON_GETRFParam)->SetWindowText(theApp.g_LoadString("IDWQE_C0072"));//ȡ
	GetDlgItem(IDC_BUTTON_SETRFParam)->SetWindowText(theApp.g_LoadString("IDWQE_C0073"));//ò
	

	GetDlgItem(IDC_CHECK_Vibrate)->SetWindowText(theApp.g_LoadString("IDWQE_C0074"));//
	GetDlgItem(IDC_STATIC_MODULETYPE)->SetWindowText(theApp.g_LoadString("IDWQE_C0075"));//ģ

	
}

void VH73BParam::UpdateStatus()//ʹ벻ʹ
{
	GetDlgItem(IDC_BUTTON_SETPARAM)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_READPARAM)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_SETFACPARAM)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_RESTOREFACPARAM)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_PARAMSET)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_GETTIME)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_SETTIME)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_SETFILTER)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_GETFILTER)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_ReaderGETBLUEID)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_ReadSETID)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_GETRFParam)->EnableWindow(ifConnectReader);
	GetDlgItem(IDC_BUTTON_SETRFParam)->EnableWindow(ifConnectReader);
}

BOOL VH73BParam::OnSetActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	if ( ifConnectReader )
	{
		//˵
		//
		ReadParameter();
		
	
	}
	else
	{
		
		
	}

	//////////////////////////////////////////////////////////////////////////
	UpdateStatus();//ʹ벻ʹ

	return CPropertyPage::OnSetActive();
}

BOOL VH73BParam::OnKillActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CPropertyPage::OnKillActive();
}

BOOL VH73BParam::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	// TODO: Add extra initialization here
	gReaderParamHwnd	=	this->GetSafeHwnd();	//ľ


	//汾ΰ汾
	GetDlgItem(IDC_EDIT_PARAMMainVer)->SetWindowText(_T("0"));
	GetDlgItem(IDC_EDIT_PARAMSecondVer)->SetWindowText(_T("0"));

	CComboBox *m_USBRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_USBRATE);
	m_USBRate->AddString("9600");
	m_USBRate->AddString("19200");
	m_USBRate->AddString("38400");
	m_USBRate->AddString("57600");
	m_USBRate->AddString("115200");
	m_USBRate->SetCurSel(0);


	//////////////////////////////////////////////////////////////////////////
	UpdateStatus();//ʹ벻ʹ

	//////////////////////////////////////////////////////////////////////////
	//ܹ˽˵Ҫ,modify by mqs 20130226
	GetDlgItem(IDC_BUTTON_SETFACPARAM)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_BUTTON_RESTOREFACPARAM)->ShowWindow(SW_HIDE);


	//汾ΰ汾Щ֮
	GetDlgItem(IDC_STATIC_PARAMHardVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_EDIT_PARAMHardVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_STATIC_PARAMSoftVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_EDIT_PARAMSoftVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_STATIC_PARAMMainVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_EDIT_PARAMMainVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_STATIC_PARAMSecondVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_EDIT_PARAMSecondVer)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_BUTTON_PARAMSET)->ShowWindow(SW_HIDE);
	//////////////////////////////////////////////////////////////////////////


	//
	::PostMessage(gReaderParamHwnd,WM_READERPARMDATAMSG,2,0);	//convert language

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void VH73BParam::OnDestroy() 
{
	CPropertyPage::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

void VH73BParam::OnBUTTONReaderGETBLUEID() 
{
	// TODO: Add your control notification handler code here
	// ȡID
	//ȡID
	int res;
	CString str;
	
	BYTE sReaderID[32];
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	res=GetHandsetID(m_hScanner,sReaderID);
	
	str.Empty(); 
	if(res==_OK)
	{
		for(int i=0;i<10;i++)
		{
			str+=sReaderID[i];
		}
		GetDlgItem(IDC_EDIT_ReadVHID)->SetWindowText(str);
	}
	else
	{
		//MessageBox("ȡֳֻIDŴ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0016"));
	}
	
	UpdateData(FALSE);

}

void VH73BParam::OnBUTTONReadSETID() 
{
	// TODO: Add your control notification handler code here
	//ID
	//ȡID
	int res;
	
	BYTE sReaderID[32];
	CString m_HandsetID	=	_T("");
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	UpdateData(TRUE);
	
	GetDlgItem(IDC_EDIT_ReadVHID)->GetWindowText(m_HandsetID);
	if((m_HandsetID.GetLength()<=0)||(m_HandsetID.GetLength()>10))
	{
		//MessageBox("дID!");
		MessageBox(theApp.g_LoadString("IDWQE_D0017"));
		return;
	}
	
	memset(sReaderID,0,32);
	memcpy(sReaderID,m_HandsetID.GetBuffer(m_HandsetID.GetLength()),m_HandsetID.GetLength()); 
	
	res=SetHandsetID(m_hScanner,sReaderID);
	
	if(res==_OK)
	{
		//MessageBox("ֳֻIDóɹ!");
		MessageBox(theApp.g_LoadString("IDWQE_D0018"));
	}
	else
	{
		//MessageBox("ֳֻIDô!");
		MessageBox(theApp.g_LoadString("IDWQE_D0019"));
	}
	
	return;
}

void VH73BParam::OnButtonSetparam() 
{
	// TODO: Add your control notification handler code here
	//ò
	SetParameterTest(1);

	return;
}

void VH73BParam::OnButtonReadparam() 
{
	// TODO: Add your control notification handler code here
	//ȡ
	ReadParameter();

	return;
}

void VH73BParam::OnButtonSetfacparam() 
{
	// TODO: Add your control notification handler code here
	//ó
	SetParameterTest(0);

	return;
}

void VH73BParam::OnButtonRestorefacparam() 
{
	// TODO: Add your control notification handler code here
	//ָ
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset!","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	apiReturn res;
	res=ReadFactoryParameter(m_hScanner);
	if(res==0)
	{
		ReadParameter();
	}

	return;
}

void VH73BParam::OnButtonParamset() 
{
	// TODO: Add your control notification handler code here
	//ΰ汾
	int res;
	CString str;
	int m_HarVer	=	0;
	int m_HarVer2	=	0;

	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	UpdateData(TRUE);
	
	GetDlgItem(IDC_EDIT_RFmodeHardVer)->GetWindowText(str);
	m_HarVer	=	atoi(str);
	if((m_HarVer<0)||(m_HarVer>255))
	{
		//MessageBox("дӲ汾!");
		MessageBox(theApp.g_LoadString("IDWQE_C0044"));
		return;
	}
	
	GetDlgItem(IDC_EDIT_RFmodeHardVer2)->GetWindowText(str);
	m_HarVer2	=	atoi(str);
	if((m_HarVer2<0)||(m_HarVer2>255))
	{
		//MessageBox("дӲ汾!");
		MessageBox(theApp.g_LoadString("IDWQE_C0045"));
		return;
	}
	
	res=SetHardVersion(m_hScanner,m_HarVer,m_HarVer2);
	if(res==_OK)
	{
		//MessageBox("ֳֻӲ汾ųɹ!");
		MessageBox(theApp.g_LoadString("IDWQE_C0046"));
	}
	else
	{
		//MessageBox("ֳֻӲ汾Ŵ!");
		MessageBox(theApp.g_LoadString("IDWQE_C0047"));
	}
	

	return;

}

void VH73BParam::OnButtonGettime() 
{
	// TODO: Add your control notification handler code here
	//ȡʱ
	apiReturn res;
	CString str;
	ReaderDate time;
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	res=GetReaderTime(m_hScanner,&time);	
	
	if(res == _OK)
	{
		str.Format("20%02d-%02d-%02d %02d:%02d:%02d",time.Year,time.Month,time.Day,time.Hour,time.Minute,time.Second);
		
	}
	else
	{
		//str="Get Time Fail!";
		str=theApp.g_LoadString("IDWQE_C0051");
		
	}
	GetDlgItem(IDC_EDIT4)->SetWindowText(str);

	UpdateData(FALSE);

	return;
}

void VH73BParam::OnButtonSettime() 
{
	// TODO: Add your control notification handler code here
	//ʱ
	apiReturn res;
	CString str;
	ReaderDate time;
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	UpdateData(TRUE);
	
	CTime m_NowTime = CTime::GetCurrentTime();
	
	
	time.Year=m_NowTime.GetYear()%100;
	time.Month=m_NowTime.GetMonth();
	time.Day=m_NowTime.GetDay();
	time.Hour=m_NowTime.GetHour();
	time.Minute=m_NowTime.GetMinute();
	time.Second=m_NowTime.GetSecond();
	
	res=SetReaderTime(m_hScanner,&time);	
	if(res == _OK)
	{
		//str	=	("Set Time successfully!");
		str	=	theApp.g_LoadString("IDWQE_C0048");
	}
	else
	{
		//str="Set Time Fail!";
		str	=	theApp.g_LoadString("IDWQE_C0049");
		
	}
	GetDlgItem(IDC_EDIT4)->SetWindowText(str);


	return;

}

void VH73BParam::OnButtonSetfilter() 
{
	// TODO: Add your control notification handler code here
	//ù
	UpdateData(TRUE);
	
	apiReturn res;
	
	int i,m,str_len,filterLength;
	CString str;
	BYTE FilterMask[64];
	
	int m_FilterAddress	=	0;
	int m_FilterLength	=	0;
	CString m_FilterMask	=	_T("");

	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	GetDlgItem(IDC_EDIT_MASKSTARTADDR)->GetWindowText(str);
	m_FilterAddress	=	atoi(str);
	if ((m_FilterAddress<0) || (m_FilterAddress>95))
	{
		//MessageBox("Please input Address of Tag EPC between 0 and 95 !","Error",MB_ICONERROR);
		MessageBox(theApp.g_LoadString("IDWQE_C0052"), theApp.g_LoadString("IDWQE_C0053"), MB_ICONERROR);
		return;
	}


	GetDlgItem(IDC_EDIT_MASKLENGTH)->GetWindowText(str);
	m_FilterLength	=	atoi(str);
	if ((m_FilterLength<0) || (m_FilterLength>96))
	{
		//MessageBox("Please input Address of Tag EPC between 0 and 96 !","Error",MB_ICONERROR);
		MessageBox(theApp.g_LoadString("IDWQE_C0054"), theApp.g_LoadString("IDWQE_C0055"), MB_ICONERROR);
		return;
	}
	
	
	GetDlgItem(IDC_EDIT_MASKDATA)->GetWindowText(str);
	m_FilterMask	=	str;

	str="";
	str=m_FilterMask.SpanIncluding("0123456789ABCDEFabcdef");
	if(strlen(str)!=strlen(m_FilterMask))
	{
		//MessageBox("Please input HEX!","Warning",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_C0056"), theApp.g_LoadString("IDWQE_C0057"), MB_ICONWARNING);
		GetDlgItem(IDC_EDIT_MASKDATA)->SetFocus();
		((CEdit *) GetDlgItem(IDC_EDIT_MASKDATA))->SetSel(0,-1);
		UpdateData(FALSE);
		return;
	}
	
	str_len=strlen(m_FilterMask);
	str=m_FilterMask;
	
	if (m_FilterLength==0)
		m=0;
	else
	{
		m=m_FilterLength/8;
		if (m_FilterLength%8!=0)
		{
			for(i=0;i<((m+1)*2-str_len);i++)
				str+="0";
			m++;
		}
	}
	filterLength=m_FilterLength;
	
	
	for(i=0;i<m;i++)
	{
		FilterMask[i]=(BYTE)strtol(((CString)str[i*2]+(CString)str[i*2+1]),NULL,16);
	}
	
	if (m_FilterAddress+filterLength>96)
		filterLength=8-m_FilterAddress;
	
	res=SetReportFilter(m_hScanner,m_FilterAddress,filterLength,FilterMask);
	
	if (res!=_OK)
	{
		//str="Set ReportFilter Parameter Fail!";
		str=theApp.g_LoadString("IDWQE_C0058");
		MessageBox(str,theApp.g_LoadString("IDWQE_C0059"), MB_ICONERROR);
		return;
	}
	
	return;
}

void VH73BParam::OnButtonGetfilter() 
{
	// TODO: Add your control notification handler code here
	//ȡ
	apiReturn res;
	
	int i,l,FilterAddress=0,FilterLength=0;;
	CString str,str_temp;
	BYTE FilterMask[64];

	int m_FilterAddress	=	0;
	int m_FilterLength	=	0;
	CString m_FilterMask	=	_T("");
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	for(i=0;i<3;i++)
	{		
		res=GetReportFilter(m_hScanner,&FilterAddress,&FilterLength,&FilterMask[0]);
		if (res==_OK) break;
	}
	if (res!=_OK)
	{
		//MessageBox("Read ReportFilter Parameter Fail!","Error",MB_ICONERROR);
		MessageBox(theApp.g_LoadString("IDWQE_C0060"), theApp.g_LoadString("IDWQE_C0061"), MB_ICONERROR);
		return ;
	}
	
	m_FilterAddress=FilterAddress;
	m_FilterLength=FilterLength;
	
	if (FilterLength%8==0)
	{
		l=FilterLength/8;
	}
	else
	{
		l=FilterLength/8+1;
	}
	
	str="";
	for(i=0;i<l;i++)
	{
		str_temp.Format("%02X",FilterMask[i]);
		str+=str_temp;
	}
	m_FilterMask=str;
	


	str.Format(_T("%d"), m_FilterAddress);
	GetDlgItem(IDC_EDIT_MASKSTARTADDR)->SetWindowText(str);

	str.Format(_T("%d"), m_FilterLength);
	GetDlgItem(IDC_EDIT_MASKLENGTH)->SetWindowText(str);

	str.Format(_T("%s"), m_FilterMask);
	GetDlgItem(IDC_EDIT_MASKDATA)->SetWindowText(str);


	UpdateData(FALSE);

	return;
}

void VH73BParam::OnBUTTONGETRFParam() 
{
	// TODO: Add your control notification handler code here
	//ȡRFģĲ
	ReadParameter();
}

void VH73BParam::OnBUTTONSETRFParam() 
{
	// TODO: Add your control notification handler code here
	//RFģĲ
	SetParameterTest(1);
}

BOOL VH73BParam::ReadParameter()
{
	apiReturn res;
	
	int i=0;
	CString str="",str_temp="";

	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return -1;
	}

	str.Format("%02d%02d",(m_HardVersion>>8) & 0xFF,m_HardVersion & 0xFF);
	//m_HardVer=str;//Ӳ汾
	GetDlgItem(IDC_EDIT_PARAMHardVer)->SetWindowText(str);
	str.Format("%02d%02d",(m_SoftVersion>>8) & 0xFF,m_SoftVersion & 0xFF);
	//m_SoftVer=str;//汾
	GetDlgItem(IDC_EDIT_PARAMSoftVer)->SetWindowText(str);

	UpdateData(FALSE);

	for(i=0;i<3;i++)
	{	
		Sleep(10);
		res=ReadHanderParam(m_hScanner,&Param);
		if (res==_OK) break;
	}
	if (res!=_OK)
	{
		//MessageBox("Read Basic Parameter Fail!","Error",MB_ICONERROR);
		MessageBox(theApp.g_LoadString("IDWQE_C0062"), theApp.g_LoadString("IDWQE_C0063"), MB_ICONERROR);
		return FALSE;
	}

	int m_Alarm=Param.Alarm & 0x01;
	//buzzer
	((CButton*)GetDlgItem(IDC_CHECK_ALARM))->SetCheck(m_Alarm);

	//
	int m_IsLable=(Param.Alarm>>1)&0x01;
	((CButton*)GetDlgItem(IDC_CHECK_NAME))->SetCheck(m_IsLable);

	if(Param.TagType==0x01)
	{
		m_TagType=0;
	}
	if(Param.TagType==0x04)
	{
		m_TagType=1;
	}
	m_OutputType=Param.OutputMode;
	CComboBox *m_USBRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_USBRATE);
	m_USBRate->SetCurSel(Param.USBBaudRate-4);

	int m_Power=Param.Power;//书
	str.Format(_T("%d"), m_Power);
	GetDlgItem(IDC_EDIT_RFPower)->SetWindowText(str);

	int m_IsTID=Param.ISTID;//ǷTID
	((CButton*)GetDlgItem(IDC_CHECK_TIDPART))->SetCheck(m_IsTID);
	
	int m_TIDAddr=Param.TIDAddr;//TIDȡλ
	str.Format(_T("%d"), m_TIDAddr);
	GetDlgItem(IDC_EDIT_TIDSTART)->SetWindowText(str);

	int m_TIDLen=Param.TIDLen;//TIDȡ
	str.Format(_T("%d"), m_TIDLen);
	GetDlgItem(IDC_EDIT_TIDLength)->SetWindowText(str);

	int m_IsUSER=Param.ISUSER;//ǷUser
	((CButton*)GetDlgItem(IDC_CHECK_PARTUSER))->SetCheck(m_IsUSER);

	int m_USERAdder=Param.USERAddr;//Userȡλ
	str.Format(_T("%d"), m_USERAdder);
	GetDlgItem(IDC_EDIT_USERSTART)->SetWindowText(str);

	int m_USERLen=Param.USERLen;//Userȡ
	str.Format(_T("%d"), m_USERLen);
	GetDlgItem(IDC_EDIT_UserLength)->SetWindowText(str);

	//ISVibrate;		//,0-1-													(18)
	int m_IsVibrate=Param.ISVibrate;
	((CButton*)GetDlgItem(IDC_CHECK_Vibrate))->SetCheck(m_IsVibrate);


	HVer1=Param.RFhrdVer1;
	HVer2=Param.RFhrdVer2;
	SVer1=Param.RFSoftVer1;
	SVer2=Param.RFSoftVer2;

	int SoftVersion=Param.RFSoftVer1*0x100+Param.RFSoftVer2;
	int HardVersion=Param.RFhrdVer1*0x100+Param.RFhrdVer2;
	int NumofFreq;
	double Freq,jumpFreq;
	BOOL ischina=FALSE;
	BOOL AM=FALSE;

	CComboBox *m_MinFre	=	(CComboBox*)GetDlgItem(IDC_COMBO_MINFREQ);
	CComboBox *m_MaxFre	=	(CComboBox*)GetDlgItem(IDC_COMBO_MAXFREQ);
	m_MinFre->ResetContent();
	m_MaxFre->ResetContent();

    switch(SoftVersion & 0xFF)
	{
	case 0x00:
		NumofFreq=63;
		Freq=902.6;
		jumpFreq=0.4;
		break;
	case 0x01:
		NumofFreq=125;
		Freq=902.6;
		jumpFreq=0.2;
		break;
	case 0x02:
		NumofFreq=11;
		Freq=865.5;
		jumpFreq=0.2;
		break;
	case 0x03:
		NumofFreq=8;
		Freq=902.6;
		jumpFreq=3.6;
		break;
	case 0x04:
		NumofFreq=10;
		Freq=952.2;
		jumpFreq=0.2;
		break;
	case 0x05:
		NumofFreq=42;
		Freq=919.2;
		jumpFreq=0.2;
		break;
	case 0x06:
		NumofFreq=16;
		Freq=920.625;
		jumpFreq=0.25;
		ischina=TRUE;
		break;
//
	case 0x07:
		NumofFreq=16;
		Freq=910.5;
		jumpFreq=0.2;
		break;
	case 0x08:
		NumofFreq=50;
		Freq=902.75;
		jumpFreq=0.5;
		AM=TRUE;
		break;
	case 0x09:
		NumofFreq=16;
		Freq=840.625;
		jumpFreq=0.25;
		ischina=TRUE;
		break;
	default:
		NumofFreq=63;
		Freq=902.6;
		jumpFreq=0.4;
	}

	for(i=0; i<NumofFreq; i++)
	{

		if (ischina)
		{
			str_temp.Format("%d:%7.3f",i+1, Freq+i*jumpFreq);
		
		}
		else
		{
			if(AM==TRUE)
			{
				str_temp.Format("%d:%5.2f",i+1, Freq+i*jumpFreq);
			}
			else
			{
				str_temp.Format("%d:%5.1f",i+1, Freq+i*jumpFreq);
			}
		
		}
		m_MinFre->AddString(str_temp);
		m_MaxFre->AddString(str_temp);
	}

	str.Format("%02d%02d",(HardVersion>>8) & 0xFF,HardVersion & 0xFF);
	//m_RFHardVer=str;
	GetDlgItem(IDC_EDIT_RFmodeHardVer)->SetWindowText(str);

	str.Format("%02d%02d",(SoftVersion>>8) & 0xFF,SoftVersion & 0xFF);
	//m_RFSoftVer=str;
	GetDlgItem(IDC_EDIT_RFmodeHardVer2)->SetWindowText(str);

	m_MinFre->SetCurSel(Param.Min_Frequence-1);
	m_MaxFre->SetCurSel(Param.Max_Frequence-1); 


	//ģ,0---R2000, 1---VM5E											(19)
	int m_Modutype=Param.Modutype;
	str.Format(_T("%d"), m_Modutype);
	GetDlgItem(IDC_EDIT_MODUETYPE)->SetWindowText(str);

	UpdateData(FALSE);

	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
//;:		в
//:	SetParameterTest
//:		
//:	nCmd 0---̲,1---ͨ
//:	
//ֵ:	
//ע:		
//////////////////////////////////////////////////////////////////////////
void VH73BParam::SetParameterTest(int nCmd)
{
	
	UpdateData(TRUE);
	apiReturn res;
	//HandsetParam Param;
	int Alarm;
	CString strText;
	
	if(!ifConnectReader)
	{
		//MessageBox("Can't connect a handset !","Notice",MB_ICONWARNING);
		MessageBox(theApp.g_LoadString("IDWQE_B0015"), theApp.g_LoadString("IDWQE_B0016"), MB_OK | MB_ICONERROR);
		return;
	}
	
	Alarm=1;
	//buzzer
	int m_Alarm		=	((CButton*)GetDlgItem(IDC_CHECK_ALARM))->GetCheck();
	if(!m_Alarm)
	{
		Alarm=0;
	}
	

	int m_IsLable	=	((CButton*)GetDlgItem(IDC_CHECK_NAME))->GetCheck();
	if(m_IsLable)
	{
		Alarm+=2;
	}
	
	Param.Alarm =Alarm;
	Param.OutputMode =m_OutputType;
	Param.TagType=0x04;
	if(m_TagType==0)
	{
		Param.TagType =0x01;
	}
	
	CComboBox *m_USBRate	=	(CComboBox*)GetDlgItem(IDC_COMBO_USBRATE);
	Param.USBBaudRate=m_USBRate->GetCurSel()+4;

	
	CComboBox *m_MinFre	=	(CComboBox*)GetDlgItem(IDC_COMBO_MINFREQ);
	CComboBox *m_MaxFre	=	(CComboBox*)GetDlgItem(IDC_COMBO_MAXFREQ);
	Param.Min_Frequence =m_MinFre->GetCurSel()+1;
	Param.Max_Frequence =m_MaxFre->GetCurSel()+1;


	int m_Power	=	0;//书
	GetDlgItem(IDC_EDIT_RFPower)->GetWindowText(strText);
	m_Power	=	atoi(strText);
	Param.Power =m_Power;

	int m_IsTID	=	0;//ǷTID
	m_IsTID	=	((CButton*)GetDlgItem(IDC_CHECK_TIDPART))->GetCheck();
	Param.ISTID =m_IsTID;

	int m_TIDAddr=	0;//TIDȡλ
	GetDlgItem(IDC_EDIT_TIDSTART)->GetWindowText(strText);
	m_TIDAddr	=	atoi(strText);
	Param.TIDAddr =	m_TIDAddr;

	int m_TIDLen=	0;//TIDȡ
	GetDlgItem(IDC_EDIT_TIDLength)->GetWindowText(strText);
	m_TIDLen	=	atoi(strText);
	Param.TIDLen =	m_TIDLen;
	if ( 0 == m_TIDLen )
	{
		MessageBox("Can't m_TIDLen is 0 !","Notice",MB_ICONWARNING);
		return;
	}


	int m_IsUSER=	0;//ǷUser
	m_IsUSER	=	((CButton*)GetDlgItem(IDC_CHECK_PARTUSER))->GetCheck();
	Param.ISUSER =m_IsUSER;

	int m_USERAdder=0;//Userȡλ
	GetDlgItem(IDC_EDIT_USERSTART)->GetWindowText(strText);
	m_USERAdder	=	atoi(strText);
	Param.USERAddr =m_USERAdder;

	int m_USERLen=	0;//Userȡ
	GetDlgItem(IDC_EDIT_UserLength)->GetWindowText(strText);
	m_USERLen	=	atoi(strText);
	Param.USERLen =m_USERLen;
	if ( 0 == m_USERLen )
	{
		MessageBox("Can't m_USERLen is 0 !","Notice",MB_ICONWARNING);
		return;
	}
	

	int m_IsVibrate=	0;//,0-1-													(18)
	m_IsVibrate	=	((CButton*)GetDlgItem(IDC_CHECK_Vibrate))->GetCheck();
	Param.ISVibrate =m_IsVibrate;
	
	//ģ,0---R2000, 1---VM5E											(19)
	int m_Modutype=0;
	GetDlgItem(IDC_EDIT_MODUETYPE)->GetWindowText(strText);
	m_Modutype	=	atoi(strText);
	Param.Modutype =m_Modutype;	

	Param.RFhrdVer1=HVer1; 
	Param.RFhrdVer2=HVer2; 
	Param.RFSoftVer1=SVer1; 
	Param.RFSoftVer1=SVer1; 
	
	if(nCmd==1)
	{
		res=WriteHanderParam(m_hScanner,&Param);
		if(res==_OK)
		{
			//MessageBox("óɹ,ֳֻ");
			MessageBox(theApp.g_LoadString("IDWQE_C0064"));
			
			///:	lOpt Ϊַʽͨ(0--TCP/IP, 1--RS232,2--RS485, 3--USB)
			switch ( ConnectMode )
			{
			case 1://RS232
				//Ͽд
				DisconnectScanner(m_hScanner);
				break;
			case 3://USB
				//Ͽд
				VH_DisconnectScannerUsb(m_hScanner);
				break;
				
			}

			ifConnectReader=0;
			NewConnect=0;
			m_HardVersion=0;
			m_SoftVersion=0;

			::PostMessage(gMainHwnd,WM_LISTUSERDATA,3,0);	//һ
		}
		else
		{
			//MessageBox("ʧ");
			MessageBox(theApp.g_LoadString("IDWQE_C0065"));
		}
	}
	else
	{
// 		res=WriteFactoryParam(m_hScanner,&Param);
// 		if(res==_OK)
// 		{
// 			//MessageBox("óɹ");
// 			MessageBox(theApp.g_LoadString("IDWQE_C0066"));
// 		}
// 		else
// 		{
// 			//MessageBox("ʧ");
// 			MessageBox(theApp.g_LoadString("IDWQE_C0067"));
// 		}
	}
	
	
	return;

}


//WM_READERPARMDATAMSG
afx_msg LRESULT VH73BParam::OnReaderparmdatamsg(WPARAM wParam, LPARAM lParam)
{
	int iwParam	=	(int)wParam;
	int ilParam	=	(int)lParam;
	
	if ( 2 == iwParam )
	{
		OnInitUIText();	//
	}
	else if( 0 == iwParam )
	{
		if ( 0 == ilParam )
		{
			CString   strTime;
			//SYSTEMTIME   time;   
			//GetSystemTime(&time);GetCurrentTime() 
			//sprintf(strTime.GetBuffer(MAX_PATH),_T("%04d-%02d-%02d %02d:%02d:%02d"),time.wYear,time.wMonth,time.wDay,
			//	time.wHour,time.wMinute,time.wSecond);
			//strTime.ReleaseBuffer();
			
			
			
			CTime t = CTime::GetCurrentTime();
			
			
			
			strTime.Format("%04d-%02d-%02d %02d:%02d:%02d", t.GetYear(), t.GetMonth(), t.GetDay(),
				t.GetHour(), t.GetMinute(), t.GetSecond() );
			
			//費Ҫ
			//GetDlgItem(IDC_STATIC_TIMEA)->SetWindowText(strTime);//ʱ
			
		}
	}
	else if ( 4 == iwParam )
	{
		if ( 0 == ilParam )
		{
			UpdateStatus();//ʹ벻ʹ
		}
	}

	return 0;
}



